/***************************************************************/
//
//
//		DirectX	[dome.cpp]
//
//												Author	kazuki tanaka
//												Date	2016 11/28
/*---------------------------------------------------------------
Update : 2016/04/18
			bZ[W{bNX\
Update : 2016/04/25


/*---------------------------------------------------------------
	wb_[t@C
---------------------------------------------------------------*/
#include "main.h"
#include "dome.h"

#include "d_console.h"
#include "d_log.h"

/*---------------------------------------------------------------
	}N`
---------------------------------------------------------------*/

#define NUM_VERTEX (4)									// STRIP

#define NUM_Dome (2)

#define RADIAN( theta ) ((( theta ) * D3DX_PI ) / 180 )	// WApւ̕ϊ

/*---------------------------------------------------------------
	萔`
---------------------------------------------------------------*/

#define Z_SDW_ROTATION ( 360 )
#define Y_SDW_ROTATION ( 90 )

/*---------------------------------------------------------------
	vg^Cv錾
---------------------------------------------------------------*/

void MakeVertexDome(LPDIRECT3DDEVICE9 pDevice);		// _̍쐬

/*----------------------------------------------------------------
	O[oϐ
----------------------------------------------------------------*/

LPDIRECT3DTEXTURE9 g_pTextureDome=nullptr;			// eNX`-C^[tF-Xp

LPDIRECT3DVERTEXBUFFER9 g_pVtxBufferDome = nullptr;	// _obt@C^[tF[Xւ̃|C^
LPDIRECT3DINDEXBUFFER9 g_pIdxBufferDome  = nullptr;	// CfbNXobt@C^[tF[Xւ̃|C^

DOME_SIZE g_Dome;



// |S̏
void InitDome( void )
{
	
	g_Dome.number   = 10;
	g_Dome.radius   = 200;
	g_Dome.coord  = D3DXVECTOR3( 0, 0, 0 );  


	// foCX󂯎p֐
	LPDIRECT3DDEVICE9 g_pPD3DDevice = GetDevice( );

	MakeVertexDome(g_pPD3DDevice);

	// eNX`̓ǂݍ 
	if( FAILED( D3DXCreateTextureFromFile( g_pPD3DDevice, "data\\TEXTURE\\sky000.jpeg", &g_pTextureDome ))){

		#ifdef _DEBUG
		MessageBox( NULL, "DomeeNX`t@C̓ǂݍ݂Ɏs܂!" , "TEXTURE LOAD ERROR!!", MB_OK | MB_ICONWARNING );
		#endif	// _DEBUG
	}
	
}

// |S̏
void UninitDome( void )
{

	SAFE_RELEASE( g_pTextureDome )

	SAFE_RELEASE( g_pVtxBufferDome )

	SAFE_RELEASE( g_pIdxBufferDome )

}

// |S̍XV
void UpdateDome( void )
{
	/*
	VERTEX_3D* pVtx;
	
	g_pVtxBufferDome -> Lock( 0, 0, (void**)&pVtx, 0 );
	
	for( int index = 0; index < (( g_Dome.number*((g_Dome.number*4)+1) ) + 1 ); index++ ){
	
		pVtx[ index ].tex.x += 0.001f;
	}

	g_pVtxBufferDome ->Unlock( );
	*/
}

// |S̕`
void DrawDome( void )
{


	// foCX̎󂯎
	LPDIRECT3DDEVICE9 pDevice = GetDevice( );

	D3DXMATRIX mtxDefault;
	D3DXMATRIX rotMtx;

	// Pʍsւ̏( sPʍsɂ )
	D3DXMatrixIdentity( &mtxDefault );

	static D3DXVECTOR3 rot( 0, 0.1f, 0 );

	rot.y += 0.1f;

	D3DXMatrixRotationYawPitchRoll( &rotMtx, D3DXToRadian(rot.y), rot.x, rot.z );
	
	mtxDefault = rotMtx;

	// foCXɃ[hϊsݒ
	pDevice ->SetTransform( D3DTS_WORLD, &mtxDefault );

	// Xg[
	pDevice ->SetStreamSource( 0,
	g_pVtxBufferDome,								// Xg[ɃoCh钸_obt@
	0,												// Xg[擪璸_f[^擪܂ł̃ItZbg (oCgP)
	sizeof( VERTEX_3D ));							// ̃XgChl(oCgP)

	// _tH[}bg̐ݒ
	pDevice->SetFVF( FVF_VERTEX_3D );

	// CfbNXobt@̐ݒ
	pDevice ->SetIndices( g_pIdxBufferDome );

	// eNX`̐ݒ
	pDevice->SetTexture( 0, g_pTextureDome );
	
	//pDevice ->SetRenderState( D3DRS_LIGHTING, false );

	// |S̕`
	pDevice ->DrawIndexedPrimitive( D3DPT_TRIANGLESTRIP, 0, 0, (( g_Dome.number * g_Dome.number) * 16 ) + ( (g_Dome.number-1)*2 ), 0, (g_Dome.number*4)*2*g_Dome.number + (g_Dome.number-1)*4 );

	//pDevice ->SetRenderState( D3DRS_LIGHTING, true );
	
}

// _̍쐬
void MakeVertexDome(LPDIRECT3DDEVICE9 pDevice)
{


	VERTEX_3D *pVtx;											// zAhX
	WORD      *pIndex;											// zAhXCfbNX

	// _obt@̍쐬
	if( FAILED( pDevice ->CreateVertexBuffer(
		sizeof( VERTEX_3D ) * (( g_Dome.number*((g_Dome.number*4)+1) ) + 1 ),			// mۂobt@TCY(_m) P:oCg
			D3DUSAGE_WRITEONLY,									// gp@
			FVF_VERTEX_3D,										// gp钸_tH[}bg
			D3DPOOL_MANAGED,									// obt@̊Ǘ@
			&g_pVtxBufferDome,									// i[|C^
			NULL )))
	{
		#ifdef _DEBUG
		MessageBox( NULL, "obt@ւ݂̏Ɏs܂!!" , " Dome VTXBUF ERROR !!" , MB_OK );
		#endif	// _DEBUG

		return;
	}


	// zAhX̎擾
	g_pVtxBufferDome -> Lock( 0, 0, (void**)&pVtx, 0 );


	// _obt@̐ݒ

	// CREATE MESH Dome
	for( int y = 0,x = 0; y < g_Dome.number; y++ ){

		g_Dome.theta = (Y_SDW_ROTATION/g_Dome.number) * y;

		for( x = 0; x < (g_Dome.number*4)+1 ; x++ ){

			g_Dome.phy = (Z_SDW_ROTATION/((g_Dome.number*4))) * x;
		
			pVtx[ ((g_Dome.number*4)+1)*y + (x) + 0 ].pos    = D3DXVECTOR3(
				g_Dome.radius*sinf( RADIAN( 90-g_Dome.theta ))*cosf( RADIAN( g_Dome.phy )),
				g_Dome.radius*cosf( RADIAN( 90-g_Dome.theta )),
				g_Dome.radius*sinf( RADIAN( 90-g_Dome.theta ))*sinf( RADIAN( g_Dome.phy )) );
			pVtx[ ((g_Dome.number*4)+1)*y + (x) + 0 ].tex    = D3DXVECTOR2( (( 1.0f/(g_Dome.number*4)) * x), 1.0f-(( 1.0f/g_Dome.number) * y) );
			pVtx[ ((g_Dome.number*4)+1)*y + (x) + 0 ].color  = D3DCOLOR_RGBA(255,255,255,255);
			pVtx[ ((g_Dome.number*4)+1)*y + (x) + 0 ].normal = D3DXVECTOR3( 0.0f, 1.0f, 0.0f );
		}
		if( y+1 == g_Dome.number ){

			x = 0;
			y++;

			g_Dome.theta = (Y_SDW_ROTATION/g_Dome.number) * y+1;
			g_Dome.phy = 0;
		
			pVtx[ ((g_Dome.number*4)+1)*y + (x) + 0 ].pos    = D3DXVECTOR3(
				g_Dome.radius*sinf( RADIAN( 90-g_Dome.theta ))*cosf( RADIAN( g_Dome.phy )),
				g_Dome.radius*cosf( RADIAN( 90-g_Dome.theta )),
				g_Dome.radius*sinf( RADIAN( 90-g_Dome.theta ))*sinf( RADIAN( g_Dome.phy )) );
			pVtx[ ((g_Dome.number*4)+1)*y + (x) + 0 ].tex    = D3DXVECTOR2( 0.0f, 0.0f );//D3DXVECTOR2( (( 1.0f/(g_Dome.number*4+1)) * x), (( 1.0f/g_Dome.number) * y) );
			pVtx[ ((g_Dome.number*4)+1)*y + (x) + 0 ].color  = D3DCOLOR_RGBA( 255, 255, 255, 255 );
			pVtx[ ((g_Dome.number*4)+1)*y + (x) + 0 ].normal = D3DXVECTOR3( 0.0f, 1.0f, 0.0f );
		}
	}

	/*
	#ifdef _DEBUG
	char str[4096];
	int i = g_Dome.number*(g_Dome.number*4+1) + 1;
	for( int index = 0 ; index < g_Dome.number*g_Dome.number*4 + 1; index++ ){
		sprintf( str, "index : %d \n coordX : %f \n coordY : %f \n coordZ : %f \n texU : %f \n texV : %f", index, pVtx[index].pos.x, pVtx[index].pos.y, pVtx[index].pos.z, pVtx[index].tex.x, pVtx[index].tex.y );
		MessageBox( NULL, str, "INDEX", MB_OK );
	}
	#endif	// _DEBUG
	*/

	// obt@̃AbN
	g_pVtxBufferDome ->Unlock( );


	// CfbNXobt@̒`
	if( FAILED( pDevice ->CreateIndexBuffer(
		sizeof( WORD ) * ((g_Dome.number)*(g_Dome.number*4+1) + (g_Dome.number-1)) *2,
		D3DUSAGE_WRITEONLY,
		D3DFMT_INDEX16,
		D3DPOOL_MANAGED,
		&g_pIdxBufferDome,
		NULL)))
	{
		#ifdef _DEBUG
		MessageBox( NULL, "Indexւ݂̏Ɏs܂!!", "Index Buffer ERROR !!", MB_OK | MB_ICONWARNING );
		#endif	// -> _DEBUG
		return;
	}

	// CfbNXbNzAhX擾
	g_pIdxBufferDome->Lock( 0, 0, (void**)&pIndex, 0 );

	int whiteBox;

	// _W̐ݒ
	for( int y = 0,x = 0,index = 0,alignNumber = 0,line = g_Dome.number*4+1; y < g_Dome.number; y++ ){

		// kރ|S̍쐬
		if( y ){
			
			x = 0;
			pIndex[ ((2)*line)*y + (2*x) + 0 + alignNumber*2 ] = pIndex[ ((2)*line)*y + (2*x) - 1 + alignNumber*2 ];
			pIndex[ ((2)*line)*y + (2*x) + 1 + alignNumber*2 ] = pIndex[ ((2)*line)*y + (2*x) - 1 + alignNumber*2 ] + (g_Dome.number*4)+2;
			whiteBox = pIndex[ ((2)*line)*y + (2*x) - 1 + alignNumber*2 ] + g_Dome.number*4*2;
			whiteBox = ((2)*line)*y + (2*x) + 1 + alignNumber*2;
			alignNumber++;
		}

		for( x = 0; x < line; x++ ){

			pIndex[ ((2)*line)*y + (2*x) + 1 + alignNumber*2 ] = index;

			if( (y+1) == g_Dome.number ){
				pIndex[ ((2)*line)*y + (2*x) + 0 + alignNumber*2 ] = ( g_Dome.number*4+1 )*g_Dome.number;
			}else{
				pIndex[ ((2)*line)*y + (2*x) + 0 + alignNumber*2 ] = index + (g_Dome.number*4+1);
			}
			index++;
			
		}
	}

	/*
	#ifdef _DEBUG
	char str[4096];
	int i = ((g_Dome.number)*(g_Dome.number*4+1) + (g_Dome.number-1)) *2;
	for( int index = 0 ; index < ((g_Dome.number)*(g_Dome.number*4+1) + (g_Dome.number-1)) *2; index++ ){
		sprintf( str, "%d : %d", index,pIndex[ index ] );
		MessageBox( NULL, str, "INDEX", MB_OK );
	}
	#endif	// _DEBUG
	*/

	// obt@̃AbN
	g_pIdxBufferDome ->Unlock( );



	return;

}

// MESHDome̍쐬
void CreateMeshDome( const D3DXVECTOR3 coord, const float length, const unsigned int DomeNumber )
{


	// tB[h
	SAFE_RELEASE( g_pVtxBufferDome )
	SAFE_RELEASE( g_pIdxBufferDome )

	// tB[hݒ菈
	g_Dome.number  = DomeNumber;
	g_Dome.vetical = DomeNumber;
	g_Dome.radius  = length;
	g_Dome.coord   = coord;  

	{ // tB[h

		// foCX󂯎p֐
		LPDIRECT3DDEVICE9 pDevice = GetDevice( );

		MakeVertexDome( pDevice );

	} // -> END Dome SET


}

// MESHDome̍쐬
void CreateMeshDomeCenter( const D3DXVECTOR3 coord, const float length, const unsigned int DomeNumber )
{


	// tB[h
	SAFE_RELEASE( g_pVtxBufferDome )
	SAFE_RELEASE( g_pIdxBufferDome )

	// SZo
	float harfdiamiter =  (float)((float)DomeNumber * 0.5f) * length;

	D3DXVECTOR3 centerOffset = D3DXVECTOR3( -harfdiamiter, 0, harfdiamiter );  

	// tB[hݒ菈
	g_Dome.number  = DomeNumber;
	g_Dome.vetical = DomeNumber;
	g_Dome.radius  = length;
	g_Dome.coord   = coord;  
	g_Dome.coord += centerOffset;

	{ // tB[h

		// foCX󂯎p֐
		LPDIRECT3DDEVICE9 pDevice = GetDevice( );

		MakeVertexDome( pDevice );

	} // -> END Dome SET


}


// MESHDome̍쐬
void CreateMeshDomeCenter( const float length, const unsigned int DomeNumber )
{


	// tB[h
	SAFE_RELEASE( g_pVtxBufferDome )
	SAFE_RELEASE( g_pIdxBufferDome )

	// SZo
	float harfdiamiter =  (float)((float)DomeNumber * 0.5f) * length;

	// tB[hݒ菈
	g_Dome.number   = DomeNumber;
	g_Dome.vetical  = DomeNumber;
	g_Dome.radius   = length;
	g_Dome.coord  = D3DXVECTOR3( -harfdiamiter, 0, harfdiamiter );  

	{ // tB[h

		// foCX󂯎p֐
		LPDIRECT3DDEVICE9 g_pPD3DDevice = GetDevice( );

		MakeVertexDome(g_pPD3DDevice);

	}	// -> END Dome SET

}

// MESHDome̍쐬
void CreateMeshDomeCenter( const int width, const int height, const float length )
{


	// tB[h
	SAFE_RELEASE( g_pVtxBufferDome )
	SAFE_RELEASE( g_pIdxBufferDome )

	// SZo
	float harfdiamiterX =  (float)((float)width * 0.5f) * length;
	float harfdiamiterZ =  (float)((float)height * 0.5f) * length;

	// tB[hݒ菈
	g_Dome.number   = height;
	g_Dome.vetical  = width;
	g_Dome.radius   = length;
	g_Dome.coord    = D3DXVECTOR3( -harfdiamiterX, 0, harfdiamiterZ );  

	{ // tB[h

		// foCX󂯎p֐
		LPDIRECT3DDEVICE9 g_pPD3DDevice = GetDevice( );

		MakeVertexDome(g_pPD3DDevice);

	}	// -> END Dome SET

}

// XJCh[̎擾
DOME_SIZE GetSkyDomeStatus( void )
{

	return g_Dome;

}

